#!/bin/bash
set -ex

##########################################################
# rtc1 fix
##########################################################
mkdir -p "${ROOTFS_PATH}/opt/rtc-fix/"
cp -f install/rtc-fix.sh "${ROOTFS_PATH}/opt/rtc-fix/rtc-fix.sh"
chmod +x "${ROOTFS_PATH}/opt/rtc-fix/rtc-fix.sh"
cp -f install/rtc-fix.service \
	"${ROOTFS_PATH}/lib/systemd/system"
rm "${ROOTFS_PATH}/etc/systemd/system/multi-user.target.wants/rtc-fix.service" || true
ln -s 	/lib/systemd/system/rtc-fix.service \
	"${ROOTFS_PATH}/etc/systemd/system/multi-user.target.wants"


cp -n "${ROOTFS_PATH}/usr/sbin/hwclock" "${ROOTFS_PATH}/usr/sbin/hwclock-base"

cat <<"EOF" > "${ROOTFS_PATH}/usr/sbin/hwclock"
#!/bin/bash
exec hwclock-base --rtc=/dev/rtc1 "$@"
EOF

rm /dev/rtc
ln -s /dev/rtc1 /dev/rtc
hwclock -w

